* Definicia indexovych mnozin
Set i /1*46/
    s /GJM,ALT/;

alias(i,j)

* Definicia parameterov
Parameter A1(i,j),B1(i,j),x1(j),u1(i),v1(j),
          A0(i,j),B0(i,j),x0(j),u0(i),v0(j);

$libinclude xlimport B0 C:\MaxEnt\Data\IO-96-98.xls IO96inputAGG00!a1:au47
$libinclude xlimport x0 C:\MaxEnt\Data\IO-96-98.xls IO96inputAGG00!a49:au50
$libinclude xlimport B1 C:\MaxEnt\Data\IO-96-98.xls IO98inputAGG00!a1:au47
$libinclude xlimport x1 C:\MaxEnt\Data\IO-96-98.xls IO98inputAGG00!a49:au50

    B0(i,j)=B0(i,j)/1000;
    B1(i,j)=B1(i,j)/1000;
    x0(j)=x0(j)/1000;
    x1(j)=x1(j)/1000;

    u0(i)=sum(j, B0(i,j));
    v0(j)=sum(i, B0(i,j));
    u1(i)=sum(j, B1(i,j));
    v1(j)=sum(i, B1(i,j));

Scalar F,G0,G1,N1;
    N1=sum((i,j), 1);

    A0(i,j)=B0(i,j)/x0(j);
    A1(i,j)=B1(i,j)/x1(j);

    G0=sum(j, u0(j));
    G1=sum(j, u1(j));

    F=G1;

    G1=G1/F;
    v1(j)=v1(j)/F;
    u1(i)=u1(i)/F;

* Definicia premennych a rovnic
Variables
    lambda(i)
    mi(j)
    M       entropy;

Equations
    obj_gjm    define objective function - golan & judge & miller
    obj_alt    define objective function - alternative ;

    obj_gjm..    M =e= sum(i, lambda(i)*u1(i))
                     + sum(j, log(sum(i, exp(-lambda(i)*v1(j)))));

    obj_alt..    M =e= sum(i, lambda(i)*u1(i))
                     + sum(j, mi(j)*v1(j))
                     + log(sum((i,j), exp(-(lambda(i)+mi(j))*G1)));

Model IO_GJM /obj_gjm/ ;
Model IO_ALT /obj_alt/ ;

option NLP=CONOPT2;

Parameter omega1(j),omega2,
          A1_HAT(i,j,s),B1_HAT(i,j,s),
          E_A(i,j,s),
          E_B(i,j,s),
          P_B(i,j,s);

    lambda.l(i)=0;
    mi.l(j)=0;

* Optimalizacia
    solve IO_GJM using NLP minimizing M;

       omega1(j)=sum(i, exp(-lambda.l(i)*v1(j)));
       A1_HAT(i,j,'GJM')=F*v1(j)/x1(j)*exp(-lambda.l(i)*v1(j))/omega1(j);
       B1_HAT(i,j,'GJM')=A1_HAT(i,j,'GJM')*x1(j);

    lambda.l(i)=0;
    mi.l(j)=0;

    solve IO_ALT using NLP minimizing M;

       omega2=sum((i,j), exp(-(lambda.l(i)+mi.l(j))*G1));
       A1_HAT(i,j,'ALT')=F*G1/x1(j)*exp(-(lambda.l(i)+mi.l(j))*G1)/omega2;
       B1_HAT(i,j,'ALT')=A1_HAT(i,j,'ALT')*x1(j);

       E_A(i,j,s) = A1_HAT(i,j,s)-A1(i,j);
       E_B(i,j,s) = B1_HAT(i,j,s)-B1(i,j);
       P_B(i,j,s)$B1(i,j) = abs(E_B(i,j,s))/B1(i,j);

* Vypocet parametrov
Parameter MAD_A(s),SEM_A(s),
          MAD_B(s),SEM_B(s),
          MaxPE(s),MAPE(s),
          GOF_A(s),GOF_B(s),
          CORR_A(s),CORR_B(s),
          mean_A1_HAT(s),mean_A1,
          mean_B1_HAT(s),mean_B1,
          mean0,mean1,
          stddev0,stddev1;

       MAD_A(s) = sum((i,j), abs(E_A(i,j,s)))/N1;
       SEM_A(s) = sum((i,j), power(E_A(i,j,s),2))/N1;

       MAD_B(s) = sum((i,j), abs(E_B(i,j,s)))/N1;
       SEM_B(s) = sum((i,j), power(E_B(i,j,s),2))/N1;

       MaxPE(s) = smax((i,j), P_B(i,j,s));
       MAPE(s) = sum((i,j), P_B(i,j,s))/N1;

       GOF_A(s) = sum((i,j)$A1_HAT(i,j,s), power(E_A(i,j,s),2)/(N1*A1_HAT(i,j,s)));
       mean_A1_HAT(s)=sum((i,j), A1_HAT(i,j,s))/N1;
       mean_A1=sum((i,j), A1(i,j))/N1;
       CORR_A(s) = (sum((i,j),(A1_HAT(i,j,s)-mean_A1_HAT(s))*(A1(i,j)-mean_A1))/N1)/
         (((sum((i,j),power(A1_HAT(i,j,s)-mean_A1_HAT(s),2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5);

       GOF_B(s) = sum((i,j)$B1_HAT(i,j,s), power(E_B(i,j,s),2)/(N1*B1_HAT(i,j,s)));
       mean_B1_HAT(s)=sum((i,j), B1_HAT(i,j,s))/N1;
       mean_B1=sum((i,j), B1(i,j))/N1;
       CORR_B(s) = (sum((i,j),(B1_HAT(i,j,s)-mean_B1_HAT(s))*(B1(i,j)-mean_B1))/N1)/
         (((sum((i,j),power(B1_HAT(i,j,s)-mean_B1_HAT(s),2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5);

       mean0=sum((i,j), B0(i,j))/N1;
       mean1=sum((i,j), B1(i,j))/N1;
       stddev0=sum((i,j), power((B0(i,j)-mean0),2))/N1;
       stddev1=sum((i,j), power((B1(i,j)-mean1),2))/N1;

option decimals = 5

Display MAD_A,SEM_A,
        MAD_B,SEM_B,
        MaxPE,MAPE,
        GOF_A,GOF_B,
        CORR_A,CORR_B,
        stddev0,stddev1;